/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3486;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6862;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class Modifier
implements GenericLoaderRegistry.IHaveLoader<Modifier> {
    public static final GenericLoaderRegistry.IGenericLoader<Modifier> DEFAULT_LOADER = new GenericLoaderRegistry.IGenericLoader<Modifier>(){

        public Modifier deserialize(JsonObject json) {
            return new Modifier();
        }

        public Modifier fromNetwork(class_2540 buffer) {
            return new Modifier();
        }

        public void serialize(Modifier object, JsonObject json) {
            if (object.getClass() != Modifier.class) {
                throw new IllegalStateException("Attempting to serialize a subclass of Modifier using the default modifier loader, this likely means the modifier did not override getLoader()");
            }
        }

        public void toNetwork(Modifier object, class_2540 buffer) {
        }
    };
    protected static Random RANDOM = new Random();
    public static final int DEFAULT_PRIORITY = 100;
    private ModifierId id;
    @Nullable
    private String translationKey;
    @Nullable
    private class_2561 displayName;
    @Nullable
    protected List<class_2561> descriptionList;
    @Nullable
    private class_2561 description;
    private final ModifierHookMap hooks;

    protected Modifier(ModifierHookMap hooks) {
        this.hooks = hooks;
    }

    public Modifier() {
        ModifierHookMap.Builder hookBuilder = new ModifierHookMap.Builder();
        this.registerHooks(hookBuilder);
        this.hooks = hookBuilder.build();
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
    }

    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return DEFAULT_LOADER;
    }

    public int getPriority() {
        return 100;
    }

    final void setId(ModifierId name) {
        if (this.id != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + String.valueOf((Object)name) + " Old: " + String.valueOf((Object)this.id));
        }
        this.id = name;
    }

    public ModifierId getId() {
        return Objects.requireNonNull(this.id, "Modifier has null registry name");
    }

    public final boolean is(class_6862<Modifier> tag) {
        return ModifierManager.isInTag(this.getId(), tag);
    }

    public void clearCache(class_3264 packType) {
        if (packType == class_3264.field_14188) {
            this.displayName = null;
        }
    }

    public final class_5251 getTextColor() {
        return ResourceColorManager.getTextColor((String)this.getTranslationKey());
    }

    public final int getColor() {
        return this.getTextColor().method_27716();
    }

    protected String makeTranslationKey() {
        return Util.makeTranslationKey("modifier", Objects.requireNonNull(this.id));
    }

    public final String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.makeTranslationKey();
        }
        return this.translationKey;
    }

    protected class_2561 makeDisplayName() {
        return class_2561.method_43471((String)this.getTranslationKey());
    }

    public class_5250 applyStyle(class_5250 component) {
        return component.method_27694(style -> style.method_27703(this.getTextColor()));
    }

    public class_2561 getDisplayName() {
        if (this.displayName == null) {
            this.displayName = class_2561.method_43471((String)this.getTranslationKey()).method_27694(style -> style.method_27703(this.getTextColor()));
        }
        return this.displayName;
    }

    public class_2561 getDisplayName(int level) {
        return ModifierLevelDisplay.DEFAULT.nameForLevel(this, level);
    }

    public class_2561 getDisplayName(IToolStackView tool, int level) {
        return this.getDisplayName(level);
    }

    @Deprecated
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
    }

    @Deprecated
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, slimeknights.mantle.client.TooltipKey tooltipKey, class_1836 tooltipFlag) {
        this.addInformation(tool, level, player, tooltip, TooltipKey.fromMantle(tooltipKey), tooltipFlag);
    }

    public List<class_2561> getDescriptionList() {
        if (this.descriptionList == null) {
            this.descriptionList = Arrays.asList(class_2561.method_43471((String)(this.getTranslationKey() + ".flavor")).method_27692(class_124.field_1056), class_2561.method_43471((String)(this.getTranslationKey() + ".description")));
        }
        return this.descriptionList;
    }

    public List<class_2561> getDescriptionList(int level) {
        return this.getDescriptionList();
    }

    public List<class_2561> getDescriptionList(IToolStackView tool, int level) {
        return this.getDescriptionList(level);
    }

    private static class_2561 listToComponent(List<class_2561> list) {
        if (list.isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 textComponent = class_2561.method_43470((String)"");
        Iterator<class_2561> iterator = list.iterator();
        textComponent.method_10852(iterator.next());
        while (iterator.hasNext()) {
            textComponent.method_27693("\n");
            textComponent.method_10852(iterator.next());
        }
        return textComponent;
    }

    public final class_2561 getDescription() {
        if (this.description == null) {
            this.description = Modifier.listToComponent(this.getDescriptionList());
        }
        return this.description;
    }

    public final class_2561 getDescription(int level) {
        List<class_2561> extendedDescription = this.getDescriptionList(level);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    public final class_2561 getDescription(IToolStackView tool, int level) {
        List<class_2561> extendedDescription = this.getDescriptionList(tool, level);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    public float getEffectiveLevel(IToolContext tool, int level) {
        return level;
    }

    @Deprecated
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
    }

    @Deprecated
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
    }

    @Deprecated
    public void addAttributes(IToolStackView tool, int level, class_1304 slot, BiConsumer<class_1320, class_1322> consumer) {
    }

    @Deprecated
    public void addRawData(IToolStackView tool, int level, RestrictedCompoundTag tag) {
    }

    @Deprecated
    public ValidatedResult validate(IToolStackView tool, int level) {
        return ValidatedResult.PASS;
    }

    @Deprecated
    public void beforeRemoved(IToolStackView tool, RestrictedCompoundTag tag) {
    }

    @Deprecated
    public void onRemoved(IToolStackView tool) {
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable class_1309 holder) {
        return amount;
    }

    @Deprecated
    public float getRepairFactor(IToolStackView toolStack, int level, float factor) {
        return factor;
    }

    public void onInventoryTick(IToolStackView tool, int level, class_1937 world, class_1309 holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, class_1799 stack) {
    }

    public ObjectArrayList<class_1799> processLoot(IToolStackView tool, int level, ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        return generatedLoot;
    }

    @Deprecated
    public class_1269 beforeBlockUse(IToolStackView tool, int level, class_1838 context, class_1304 slot) {
        return class_1269.field_5811;
    }

    @Deprecated
    public class_1269 afterBlockUse(IToolStackView tool, int level, class_1838 context, class_1304 slot) {
        return class_1269.field_5811;
    }

    @Deprecated
    public class_1269 beforeEntityUse(IToolStackView tool, int level, class_1657 player, class_1297 target, class_1268 hand, class_1304 slot) {
        return class_1269.field_5811;
    }

    @Deprecated
    public class_1269 afterEntityUse(IToolStackView tool, int level, class_1657 player, class_1309 target, class_1268 hand, class_1304 slot) {
        return class_1269.field_5811;
    }

    @Deprecated
    public class_1269 onToolUse(IToolStackView tool, int level, class_1937 world, class_1657 player, class_1268 hand, class_1304 slot) {
        return class_1269.field_5811;
    }

    @Deprecated
    public boolean onStoppedUsing(IToolStackView tool, int level, class_1937 world, class_1309 entity, int timeLeft) {
        return false;
    }

    @Deprecated
    public boolean onFinishUsing(IToolStackView tool, int level, class_1937 world, class_1309 entity) {
        return false;
    }

    @Deprecated
    public int getUseDuration(IToolStackView tool, int level) {
        return 0;
    }

    @Deprecated
    public class_1839 getUseAction(IToolStackView tool, int level) {
        return class_1839.field_8952;
    }

    @Deprecated
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return false;
    }

    @Deprecated
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvents.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
    }

    @Deprecated
    public void applyHarvestEnchantments(IToolStackView tool, int level, ToolHarvestContext context, BiConsumer<class_1887, Integer> consumer) {
    }

    @Deprecated
    public int getLootingValue(IToolStackView tool, int level, class_1309 holder, class_1297 target, @Nullable class_1282 damageSource, int looting) {
        return looting;
    }

    @Nullable
    @Deprecated
    public Boolean removeBlock(IToolStackView tool, int level, ToolHarvestContext context) {
        return null;
    }

    @Deprecated
    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
    }

    @Deprecated
    public void finishBreakingBlocks(IToolStackView tool, int level, ToolHarvestContext context) {
    }

    @Deprecated
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage;
    }

    @Deprecated
    public float beforeEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback;
    }

    @Deprecated
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        return 0;
    }

    @Deprecated
    public void failedEntityHit(IToolStackView tool, int level, ToolAttackContext context) {
    }

    @Deprecated
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float modifierValue) {
        return modifierValue;
    }

    @Deprecated
    public boolean isSourceBlocked(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float amount) {
        return false;
    }

    @Deprecated
    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float amount, boolean isDirectDamage) {
    }

    @Deprecated
    public void attackWithArmor(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1309 target, class_1282 source, float amount, boolean isDirectDamage) {
    }

    @Deprecated
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
    }

    @Deprecated
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
    }

    @Deprecated
    public void onEquipmentChange(IToolStackView tool, int level, EquipmentChangeContext context, class_1304 slotType) {
    }

    public boolean shouldDisplay(boolean advanced) {
        return true;
    }

    public double getDamagePercentage(IToolStackView tool, int level) {
        return Double.NaN;
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, int level) {
        return null;
    }

    public int getDurabilityRGB(IToolStackView tool, int level) {
        return -1;
    }

    @Nullable
    @Deprecated
    public <T> T getModule(Class<T> type) {
        return null;
    }

    public final <T> T getHook(ModifierHook<T> hook) {
        return this.hooks.getOrDefault(hook);
    }

    public String toString() {
        return "Modifier{" + String.valueOf((Object)this.id) + "}";
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable class_1309 living, class_1268 hand) {
        return Modifier.getHeldTool(living, Util.getSlotType(hand));
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable class_1309 living, class_1304 slot) {
        if (living == null) {
            return null;
        }
        class_1799 stack = living.method_6118(slot);
        if (stack.method_7960() || !stack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            return null;
        }
        ToolStack tool = ToolStack.from(stack);
        return tool.isBroken() ? null : tool;
    }

    public static float getMiningModifier(class_1309 entity) {
        class_1293 miningFatigue;
        float modifier = 1.0f;
        if (class_1292.method_5576((class_1309)entity)) {
            modifier *= 1.0f + (float)(class_1292.method_5575((class_1309)entity) + 1) * 0.2f;
        }
        if ((miningFatigue = entity.method_6112(class_1294.field_5901)) != null) {
            switch (miningFatigue.method_5578()) {
                case 0: {
                    modifier *= 0.3f;
                    break;
                }
                case 1: {
                    modifier *= 0.09f;
                    break;
                }
                case 2: {
                    modifier *= 0.0027f;
                    break;
                }
                default: {
                    modifier *= 8.1E-4f;
                }
            }
        }
        if (entity.method_5777(class_3486.field_15517) && !ModifierUtil.hasAquaAffinity(entity)) {
            modifier /= 5.0f;
        }
        if (!entity.method_24828()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Deprecated
    protected void addFlatBoost(class_2561 name, double bonus, List<class_2561> tooltip) {
        TooltipModifierHook.addFlatBoost(this, name, bonus, tooltip);
    }

    @Deprecated
    protected void addPercentTooltip(class_2561 name, double bonus, List<class_2561> tooltip) {
        TooltipModifierHook.addPercentBoost(this, name, bonus, tooltip);
    }

    @Deprecated
    protected void addStatTooltip(IToolStackView tool, FloatToolStat stat, class_6862<class_1792> condition, float amount, List<class_2561> tooltip) {
        TooltipModifierHook.addStatBoost(tool, this, stat, condition, amount, tooltip);
    }

    @Deprecated
    protected void addDamageTooltip(IToolStackView tool, float amount, List<class_2561> tooltip) {
        TooltipModifierHook.addDamageBoost(tool, this, amount, tooltip);
    }

    @Nullable
    protected static <M, E> E tryModuleMatch(Class<E> expected, Class<M> moduleType, M module) {
        if (moduleType == expected) {
            return (E)module;
        }
        return null;
    }

    public ModifierHookMap getHooks() {
        return this.hooks;
    }
}

